/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.foundation.resource.condition;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import plus.dragons.createcentralkitchen.CentralKitchen;
import plus.dragons.createcentralkitchen.foundation.config.CentralKitchenConfigBase;
import plus.dragons.createcentralkitchen.foundation.config.CentralKitchenConfigs;

public class ConfigListCondition
implements ICondition {
    private static final ImmutableBiMap<String, CentralKitchenConfigBase.ConfigList<String>> CONFIGS = ImmutableBiMap.builder().put((Object)"pie_overhaul_black_list", (Object)CentralKitchenConfigs.COMMON.integration.pieOverhaulBlackList).build();
    private final String name;
    private final CentralKitchenConfigBase.ConfigList<String> config;
    private final String value;

    public ConfigListCondition(String name, String value) {
        Preconditions.checkArgument((boolean)CONFIGS.containsKey((Object)name), (Object)("Id " + name + " has no config registered"));
        this.name = name;
        this.config = (CentralKitchenConfigBase.ConfigList)((Object)CONFIGS.get((Object)name));
        this.value = value;
    }

    public ConfigListCondition(CentralKitchenConfigBase.ConfigList<String> config, String value) {
        Preconditions.checkArgument((boolean)CONFIGS.containsValue(config), (Object)("Config " + config.getName() + " is not registered"));
        this.name = (String)CONFIGS.inverse().get(config);
        this.config = config;
        this.value = value;
    }

    public NotCondition blackList() {
        return new NotCondition((ICondition)this);
    }

    public ResourceLocation getID() {
        return Serializer.ID;
    }

    public boolean test(ICondition.IContext context) {
        return ((List)this.config.get()).contains(this.value);
    }

    public boolean test() {
        return this.test(ICondition.IContext.EMPTY);
    }

    public static class Serializer
    implements IConditionSerializer<ConfigListCondition> {
        private static final ResourceLocation ID = CentralKitchen.genRL("config_list");

        public void write(JsonObject json, ConfigListCondition value) {
            json.addProperty("config", value.name);
            json.addProperty("value", value.value);
        }

        public ConfigListCondition read(JsonObject json) {
            return new ConfigListCondition(GsonHelper.m_13906_((JsonObject)json, (String)"config"), GsonHelper.m_13906_((JsonObject)json, (String)"value"));
        }

        public ResourceLocation getID() {
            return ID;
        }
    }
}

